/*
    adc_stc.h

    Sampling with ADC built in MCU
    
    Copyright (c) 2020 Creative Lau (creativelaulab@gmail.com)

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
*/

#ifndef ADC_STC_H
#define ADC_STC_H

#include "config_stc.h"
#include "intrins.h"
#include "delay.h"
#include "chart.h"
#include <string.h>

#ifndef uint8
#define uint8 unsigned char
#endif

#ifndef uint16
#define uint16 unsigned int
#endif

#ifndef uint32
#define uint32 unsigned long int
#endif

#define ADC_SPEED_512 0x0F //512ʱ
#define ADC_SPEED_480 0x0E //480ʱ
#define ADC_SPEED_448 0x0D //448ʱ
#define ADC_SPEED_416 0x0C //416ʱ
#define ADC_SPEED_384 0x0B //384ʱ
#define ADC_SPEED_352 0x0A //352ʱ
#define ADC_SPEED_320 0x09 //320ʱ
#define ADC_SPEED_288 0x08 //288ʱ
#define ADC_SPEED_256 0x07 //256ʱ
#define ADC_SPEED_224 0x06 //224ʱ
#define ADC_SPEED_192 0x05 //192ʱ
#define ADC_SPEED_160 0x04 //160ʱ
#define ADC_SPEED_128 0x03 //128ʱ
#define ADC_SPEED_96 0x02  //96ʱ
#define ADC_SPEED_64 0x01  //64ʱ
#define ADC_SPEED_32 0x00  //32ʱ

#define ADC_CHS_10 0x00    //P1.0ģֵADCģͨ
#define ADC_CHS_11 0x01    //P1.1ģֵADCģͨ
#define ADC_CHS_12 0x02    //P1.2ģֵADCģͨ
#define ADC_CHS_13 0x03    //P1.3ģֵADCģͨ
#define ADC_CHS_14 0x04    //P1.4ģֵADCģͨ
#define ADC_CHS_15 0x05    //P1.5ģֵADCģͨ
#define ADC_CHS_16 0x06    //P1.6ģֵADCģͨ
#define ADC_CHS_17 0x07    //P1.7ģֵADCģͨ
#define ADC_CHS_00 0x08    //P0.0ģֵADCģͨ
#define ADC_CHS_01 0x09    //P0.1ģֵADCģͨ
#define ADC_CHS_02 0x0A    //P0.2ģֵADCģͨ
#define ADC_CHS_03 0x0B    //P0.3ģֵADCģͨ
#define ADC_CHS_04 0x0C    //P0.4ģֵADCģͨ
#define ADC_CHS_05 0x0D    //P0.5ģֵADCģͨ
#define ADC_CHS_06 0x0E    //P0.6ģֵADCģͨ
#define ADC_CHS_BG 0x0F    //16ͨڲBandGapοѹģֵADCģͨ

uint16 GetADC_CHX(uint8 chx);                 //chxͨADC
uint16 GetVoltage(uint8 chx, uint16 lsb);     //chxͨѹֵ mV
uint16 GetBGV(void);                          //ڲοѹBGV mV
uint16 *GetWaveADC(uint8 chx, uint8 scale_h); //òβ

#endif
